import math

#input
n = int(input())
goats = []
for i in range(n):
    goats.append([float(k) for k in input().split()])

#program

intersections = []
#index references to store outgoing intersections per circle, with angle for sorting
intersection_inxs = []
for i in range(n):
    intersection_inxs.append([])
    
#compute all pairwise intersection points
for i in range(n):
    for j in range(i):
        r0, x0, y0 = goats[i]
        r1, x1, y1 = goats[j]
        d = ((x0 - x1) ** 2 + (y0 - y1) ** 2) ** 0.5
        if d > r0 + r1:
            continue #no intersection
        #even if 1 solution, see it as 2 for consistency (we assume this case does not happen anyway)
        #solve intersection equation https://stackoverflow.com/questions/3349125/circle-circle-intersection-points
        a = (r0 ** 2 - r1 ** 2 + d ** 2) / (2 * d)
        h = (r0 ** 2 - a ** 2) ** 0.5
        xp2 = x0 + (a / d) * (x1 - x0)
        yp2 = y0 + (a / d) * (y1 - y0)
        xi1 = xp2 + (h / d) * (y1 - y0)
        yi1 = yp2 - (h / d) * (x1 - x0)
        xi2 = xp2 - (h / d) * (y1 - y0)
        yi2 = yp2 + (h / d) * (x1 - x0)

        #check if intersections not in the interior of any of the other circles
        out1 = True
        out2 = True
        for k in range(n):
            r,x,y = goats[k]
            if (xi1 - x) ** 2 + (yi1 - y) ** 2 < 0.999999 * r ** 2:
                out1 = False
            if (xi2 - x) ** 2 + (yi2 - y) ** 2 < 0.999999 * r ** 2:
                out2 = False
        #store points with centers in correct order (polygon to the left; counter clockwise for positive area orientation)
        #store references to outgoing intersection edges
        if out1:
            i1 = [xi1, yi1, i, j]
            intersection_inxs[i].append([math.atan2(yi1 - y0, xi1 - x0), len(intersections)])
            intersections.append(i1)
        if out2:
            i2 = [xi2, yi2, j, i]
            intersection_inxs[j].append([math.atan2(yi2 - y1, xi2 - x1), len(intersections)])
            intersections.append(i2)

#sort intersection lists on angle
for i in range(n):
    intersection_inxs[i].sort(key = lambda x: x[0])

#calculate area using arcs and trapezoid area formula by looping through the sequences derived in the step above (in a DFS-like manner)
finished = [False] * n
seen = []
for i in range(n):
    seen.append([False] * len(intersection_inxs[i]))

area = 0.0
while True:
    #find next non-finished circle
    for start in range(n):
        if not finished[start]:
            break
    else:
        break

    subarea = 0.0

    #check if circle is completely disjoint
    if len(intersection_inxs[start]) == 0:
        subarea += math.pi * goats[start][0] ** 2
        finished[start] = True
    else:
        #start with first non-seen edge
        curr = start
        for nextedge in range(n):
            if not seen[start][nextedge]:
                break
        else:
            raise Exception("No non-seen edge remains")
        #iterate until polygon is closed
        while not seen[curr][nextedge]:
            seen[curr][nextedge] = True
            finished[curr] = all(seen[curr])
            curr_intersection = intersections[intersection_inxs[curr][nextedge][1]]
            next_g = curr_intersection[3]
            #trapezoid formula
            subarea += 0.5 * (goats[curr][2] + curr_intersection[1]) * (goats[curr][1] - curr_intersection[0])
            subarea += 0.5 * (curr_intersection[1] + goats[next_g][2]) * (curr_intersection[0] - goats[next_g][1])
            #find next edge to continue traversal (next in clockwise order), and next in counter_clockwise order to add arc
            #could do a binary search but n <= 100 so we omit this
            in_angle = math.atan2(curr_intersection[1] - goats[next_g][2], curr_intersection[0] - goats[next_g][1])
            max_ang = 0.0
            min_ang = 2.0 * math.pi
            max_inx = -1
            min_inx = -1
            for inx in range(len(intersection_inxs[next_g])):
                curr_ang = intersection_inxs[next_g][inx][0] - in_angle
                if curr_ang < 0.0:
                    curr_ang += 2.0 * math.pi
                if curr_ang > max_ang:
                    max_ang = curr_ang
                    max_inx = inx
                if curr_ang < min_ang:
                    min_ang = curr_ang
                    min_inx = inx
            #add arc area
            subarea += 0.5 * min_ang * goats[next_g][0] ** 2
            #set next step
            curr = next_g
            nextedge = max_inx
    area += subarea

#output
print(area)
    
